//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Collections;
using System.Threading;

namespace DelegatesAndEvents
{
	public enum ChangeType {Add, Subtract}

	public class ChangedEventArgs : EventArgs 
	{
		private ChangeType _type;
		private int _value;
		public ChangedEventArgs(ChangeType _type, int _value)
		{
			this._type = _type;
			this._value = _value;
		}
		public ChangeType Type
		{
			get
			{
				return _type;
			}
		}
		public int Value
		{
			get
			{
				return _value;
			}
		}
	}

	public class ChangedClass 
	{
		// Zdarzenie, ktre moe by uyte do powiadomienia klientw o zmianie
		// elementw listy:
		public event EventHandler Changed;
		private int count;
		public ChangedClass()
		{
			count = 0;
		}
		// Wywoanie zdarzenia Changed przy kadej zmianie listy:
		protected void OnChanged(EventArgs e) 
		{
			if (Changed != null)
				Changed(this, e);
		}
		public void Add()
		{
			Interlocked.Increment(ref count);
			OnChanged(new ChangedEventArgs(ChangeType.Add, count));
		}
		public void Subtract()
		{
			Interlocked.Decrement(ref count);
			OnChanged(new ChangedEventArgs(ChangeType.Subtract, count));
		}
	}

	class Test 
	{
		private static void Changed(object sender, EventArgs e) 
		{
			Console.WriteLine("Wywoano Changed {0} {1}",
				              ((ChangedEventArgs)e).Value,
				              ((ChangedEventArgs)e).Type);
		}
		private static void Modified(object sender, EventArgs e) 
		{
			Console.WriteLine("Wywoano Modified {0} {1}",
				              ((ChangedEventArgs)e).Value,
				              ((ChangedEventArgs)e).Type);
		}
		// Test klasy EventHandler:
		public static void Main() 
		{
			// Utworzenie nowej listy:
			ChangedClass changed = new ChangedClass();
			changed.Changed += new EventHandler(Changed);
			changed.Changed += new EventHandler(Modified);
			changed.Add();
			changed.Add();
			changed.Changed -= new EventHandler(Modified);
			changed.Add();
			changed.Add();
			changed.Subtract();
			changed.Subtract();
			changed.Subtract();
		}
	}
}
